extends Node2D

enum npc_type { FORGERON, HERBORISTE, ALCHIMISTE, SIMPLE1, SIMPLE2, SIMPLE3};

@export var type  : npc_type
@export var _animated_sprite : AnimatedSprite2D # requires "idle" and "idle_working" animation 
@onready var interactText : RichTextLabel = $InteractIndicator
@onready var dialogueBox : CanvasLayer = $CanvasLayer
@onready var line : LineEdit = $CanvasLayer/LineEdit
@onready var text_container : VBoxContainer = $CanvasLayer/ScrollContainer/VBoxContainer
@onready var http_req : HTTPRequest = $HTTPRequest

var dialog : Array[String] = []
var idle_position = "idle"
var focus_position = "idle_working"
var loading = false

func _ready():
	dialogueBox.visible = false
	interactText.visible = false
	_animated_sprite.play(idle_position)

func interact():
	dialogueBox.visible = true
	line.grab_focus()
	print("interact")
	
var callable = Callable(self, "interact")
	
func _on_body_entered(body: Node2D):
	if body.is_in_group("player"):
		_animated_sprite.play(focus_position)
		body.interactMode += 1
		interactText.visible = true
		body.interact = callable

func _on_body_exited(body):
	if body.is_in_group("player"):
		_animated_sprite.play(idle_position)
		interactText.visible = false
		body.interactMode -= 1
		dialogueBox.visible = false
	

func _on_line_edit_text_submitted(new_text):
	if !loading:
		send_request(dialog)
		dialog.push_back(line.text)
		add_message(line.text, false)
		line.text = ""
		loading = true
		
func add_message(text: String, left = true):
	var margi = MarginContainer.new()
	margi.add_theme_constant_override("margin_top", 0)
	margi.add_theme_constant_override("margin_left", 10)
	#margi.add_theme_constant_override("margin_bottom", 5)
	margi.add_theme_constant_override("margin_right", 10)
	var label = RichTextLabel.new()
	label.bbcode_enabled = true
	label.fit_content = true
	if left:
		label.text = text + "\n"
	else:
		label.text= "[right]" + text+ "[/right]\n"
	label.scroll_active = false
	margi.add_child(label)
	text_container.add_child(margi)
	
func send_request(dialog: Array[String]):
	http_req.request(("https://google.com"))
	
	
func message_back(result, response_code, headers, body):
	#var json = JSON.parse_string(body.get_string_from_utf8())
	loading = false
	add_message("npc - la réponse de l'url : " + str(response_code))
