extends CanvasLayer

@onready var _animated_sprite = $AnimatedSprite2D
@onready var menus : Array[Control] = [ 
	$menu_items/menu_logs, $menu_items/menu_stats,
	$menu_items/menu_inventory, $menu_items/menu_quest, 
	$menu_items/menu_save, $menu_items/menu_options
]
var is_open = false

enum menu_items {LOG, STATS, INVENTORY, QUEST, SAVE, OPTIONS}

var active_menu = menu_items.STATS

func _ready():
	open_menu(2)
	_animated_sprite.play("2")
	close()

func _process(delta):
	if Input.is_action_just_pressed("inventory"):
		if is_open:
			close()
		else:
			open()
	
func close():
	is_open = false
	visible = false
	
func open():
	is_open = true
	visible = true

func _on_button_pressed1():
	open_menu(1)
	_animated_sprite.play("1")

func _on_button_pressed2():
	open_menu(2)
	_animated_sprite.play("2")

func _on_button_pressed3():
	open_menu(3)
	_animated_sprite.play("3")

func _on_button_pressed4():
	open_menu(4)
	_animated_sprite.play("4")

func _on_button_pressed5():
	open_menu(5)
	_animated_sprite.play("5")

func _on_button_pressed6():
	open_menu(6)
	_animated_sprite.play("6")
	
func open_menu(i):
	for j in range(menus.size()):
		menus[j].visible = (i -1) == j

