extends CharacterBody2D

@onready var _animated_sprite = $AnimatedSprite2D

@export var attack_speed = 1.0
var dash_animation_speed = 4.0
@export var dash_speed = 100

@export var stats: PlayerStat

var interactMode = 0
var interact: Callable

enum {TOP, DOWN, LEFT, RIGHT};
var orientation = DOWN
var target_orientation = DOWN

enum {
	IDLE, RUNNING, WALKING, 
	DASHING, 
	ATTACKING1, ATTACKING2, ATTACKING3, 
	LOOP_ATTACK1,LOOP_ATTACK2, LOOP_ATTACK3
};
var state = IDLE
var target_state = IDLE

var input_direction : Vector2

func _ready():
	print("ready");
	
func _process(_delta):
	play_animation()
	
	if interactMode > 0 && interact && Input.is_action_just_pressed("attack"):
		interact.call()
		

func _physics_process(delta):
	
	velocity = Vector2(0,0)
	
	input_direction = Input.get_vector("ui_left", "ui_right", "ui_up", "ui_down")
	update_target_orientation() # from input where to look
	update_target_state() # from input what to do
	
	if update_state() && state in [ATTACKING1]: 
		$SwordComponent.attack(orientation)
		# return true if state has changed
	
	
	if state == RUNNING:
		velocity = input_direction * delta * stats.speed * 2 * 100
	elif state == WALKING:
		velocity = input_direction * delta * stats.speed * 100
	elif state == DASHING:
		add_velocity_orientation(dash_speed,delta)
		
	move_and_slide()
	
func play_oriented_animation(animation_name, speed = 1.0):
	if orientation == DOWN:
		_animated_sprite.play("Front_" + animation_name, speed, )
	elif orientation == TOP:
		_animated_sprite.play("Back_" + animation_name, speed)
	else:
		_animated_sprite.flip_h = orientation == LEFT
		_animated_sprite.play("Side_" + animation_name, speed)
		
func add_velocity_orientation(amount, delta):
	match orientation:
		DOWN:
			velocity.y = 100 * delta * amount
		TOP:
			velocity.y = - 100 * delta * amount
		RIGHT:
			velocity.x = 100 * delta * amount
		LEFT:
			velocity.x = - 100 * delta * amount
	
func update_target_orientation():
	if input_direction.x > 0.1:
		target_orientation = RIGHT
	elif input_direction.x < -0.1:
		target_orientation = LEFT
	else:
		if input_direction.y < -0.1:
			target_orientation = TOP
		elif input_direction.y > 0.1:
			target_orientation = DOWN

func update_target_state():
	if Input.is_action_just_pressed("attack") && interactMode == 0:
		target_state = ATTACKING1
	elif Input.is_action_just_pressed("dash"):
		target_state = DASHING
	elif Input.is_action_just_pressed("secondary_attack")  && interactMode == 0:
		target_state = ATTACKING2
	elif Input.is_action_just_pressed("throw")  && !interactMode:
		target_state = ATTACKING3
	elif input_direction.x != 0 || input_direction.y != 0:
		if Input.is_action_pressed("run"):
			target_state = RUNNING
		else:
			target_state = WALKING
	else:
		target_state = IDLE

func update_state():
	if state in [IDLE, WALKING, RUNNING]:
		state = target_state
		orientation = target_orientation
		return true
	elif state == LOOP_ATTACK1:
		state = ATTACKING1
		orientation = target_orientation
		return true
	elif state == LOOP_ATTACK2:
		state = ATTACKING2
		orientation = target_orientation
		return true
	elif state == LOOP_ATTACK3:
		state = ATTACKING3
		orientation = target_orientation
		return true
	return false
	
func play_animation():
	match state:
		ATTACKING1:
			play_oriented_animation("attack", attack_speed)
		DASHING:
			play_oriented_animation("dash", dash_animation_speed)
		ATTACKING2:
			play_oriented_animation("bow", attack_speed)
		ATTACKING3:
			play_oriented_animation("throw", attack_speed)
		RUNNING:
			play_oriented_animation("run", attack_speed)
		WALKING:
			play_oriented_animation("walk", attack_speed)
		IDLE:
			play_oriented_animation("idle", attack_speed)

func _on_animated_sprite_2d_animation_finished():
	if Input.is_action_pressed("attack"):
		state = LOOP_ATTACK1
	elif Input.is_action_pressed("secondary_attack"):
		state = LOOP_ATTACK2
	elif Input.is_action_pressed("throw"):
		state = LOOP_ATTACK3
	else:
		state = IDLE

